/*============================================================================
  File:     03a - Function in Where Clause.sql

  SQL Server Versions: 2012, 2014, 2016, 2017, 2019
------------------------------------------------------------------------------
  Written by Jonathan Kehayias, SQLskills.com
  
  (c) 2019, SQLskills.com. All rights reserved.

  For more scripts and sample code, check out 
    http://www.SQLskills.com

  You may alter this code for your own *non-commercial* purposes. You may
  republish altered code as long as you include this copyright and give due
  credit, but you must obtain prior permission before blogging this code.
  
  THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF 
  ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED 
  TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
  PARTICULAR PURPOSE.
============================================================================*/

USE AdventureWorks2014
GO 
-- using function in the filter criteria

IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = 'IX_SalesOrderHeader_OrderDate')
	DROP INDEX IX_SalesOrderHeader_OrderDate ON [Sales].[SalesOrderHeader];
GO
CREATE NONCLUSTERED INDEX IX_SalesOrderHeader_OrderDate
ON [Sales].[SalesOrderHeader] ([OrderDate])
INCLUDE ([AccountNumber])
GO

SET NOCOUNT ON

DECLARE @StartTime DATETIME
SET @StartTime = GETDATE()

SELECT AccountNumber
FROM Sales.SalesOrderHeader
WHERE YEAR(OrderDate) = 2011

PRINT 'Duration with function: ' + CAST(DATEDIFF(ms, @StartTime, GETDATE()) AS varchar(10)) + ' ms'

SET @StartTime = GETDATE()

SELECT AccountNumber
FROM Sales.SalesOrderHeader
WHERE OrderDate >= '2011-01-01' 
  AND OrderDate < '2012-01-01'

PRINT 'Duration without function: ' + CAST(DATEDIFF(ms, @StartTime, GETDATE()) AS varchar(10)) + ' ms'